/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.blocks.AbstractStatueBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStatueBlockEntity
extends BlockEntity {
    public int cooldown = 0;
    public int cooldownMax = 200;
    public boolean statueAble = false;
    private int mobKilled;
    private int statueLevel;
    private boolean dropsItems;
    private float dropMultiplier;
    private boolean spawnsMobs;
    private boolean makesSounds;
    private boolean hasExternalUse;

    protected AbstractStatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("StatueCooldown");
        this.cooldownMax = compound.m_128451_("StatueMaxcooldown");
        this.statueAble = compound.m_128471_("StatueAble");
        this.loadFromNbt(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("StatueCooldown", this.cooldown);
        compound.m_128405_("StatueMaxcooldown", this.cooldownMax);
        compound.m_128379_("StatueAble", this.statueAble);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getTileData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getCooldownMax() {
        return this.cooldownMax;
    }

    public int getStatueLevel() {
        return this.statueLevel;
    }

    public float getDropMultiplier() {
        return this.dropMultiplier;
    }

    public boolean isStatueAble() {
        return this.statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        this.statueAble = statueAble;
        this.m_6596_();
    }

    public void loadFromNbt(CompoundTag compound) {
        this.mobKilled = compound.m_128451_("mobKilled");
        this.statueLevel = compound.m_128451_("statueLevel");
        this.dropsItems = compound.m_128471_("dropsItems");
        this.spawnsMobs = compound.m_128471_("spawnsMobs");
        this.makesSounds = compound.m_128471_("makesSounds");
        this.hasExternalUse = compound.m_128471_("hasExternalUse");
        this.dropMultiplier = compound.m_128457_("dropMultiplier");
    }

    public CompoundTag saveToNbt(CompoundTag compound) {
        this.saveAllTraits(compound);
        return compound;
    }

    public CompoundTag saveAllTraits(CompoundTag tag) {
        ListTag listnbt = new ListTag();
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128405_("mobKilled", this.mobKilled);
        compoundnbt.m_128405_("statueLevel", this.statueLevel);
        compoundnbt.m_128379_("dropsItems", this.dropsItems);
        compoundnbt.m_128379_("spawnsMobs", this.spawnsMobs);
        compoundnbt.m_128379_("makesSounds", this.makesSounds);
        compoundnbt.m_128379_("hasExternalUse", this.hasExternalUse);
        compoundnbt.m_128350_("dropMultiplier", this.dropMultiplier);
        listnbt.add((Object)compoundnbt);
        if (!listnbt.isEmpty()) {
            tag.m_128365_("Traits", (Tag)listnbt);
        }
        return tag;
    }

    public boolean isDecorative() {
        return !this.dropsItems && !this.spawnsMobs && !this.makesSounds && !this.hasExternalUse;
    }

    public boolean canDropItems() {
        return this.dropsItems;
    }

    public boolean canSpawnMobs() {
        return this.spawnsMobs;
    }

    public boolean makesSounds() {
        return this.makesSounds;
    }

    public boolean hasExternalUse() {
        return this.hasExternalUse;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractStatueBlockEntity blockEntity) {
        if (state.m_60734_() instanceof AbstractStatueBase && ((Boolean)state.m_61143_((Property)AbstractStatueBase.INTERACTIVE)).booleanValue() && !blockEntity.statueAble) {
            ++blockEntity.cooldown;
            blockEntity.m_6596_();
            if (blockEntity.cooldown >= blockEntity.cooldownMax) {
                blockEntity.cooldown = 0;
                blockEntity.setStatueAble(true);
            }
        }
    }
}

